/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class DirectionOrientedBillboardParticle
extends TextureSheetParticle {
    protected DirectionOrientedBillboardParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
    }

    protected DirectionOrientedBillboardParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Vec3 vec3 = renderInfo.getPosition();
        float f = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - vec3.x());
        float g = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - vec3.y());
        float h = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - vec3.z());
        Quaternionf quaternionf = new Quaternionf();
        Vec3 dir = new Vec3(this.xd, this.yd, this.zd).normalize();
        Vec3 cameraLook = new Vec3(renderInfo.getLookVector());
        Vec3 cross = dir.cross(cameraLook);
        double pitch = MthUtils.getPitch((Vec3)dir);
        double yaw = MthUtils.getYaw((Vec3)dir);
        Vector3f dirUp = new Vector3f(0.0f, 1.0f, 0.0f).rotate((Quaternionfc)quaternionf);
        float roll = dirUp.angleSigned((Vector3fc)cross.toVector3f(), (Vector3fc)dir.toVector3f());
        quaternionf.rotateY((float)(-0.01745329238474369 * yaw));
        quaternionf.rotateX((float)(0.01745329238474369 * (pitch - 90.0)));
        quaternionf.rotateY(-roll + 1.5707964f);
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float i = this.getQuadSize(partialTicks);
        for (int j = 0; j < 4; ++j) {
            Vector3f vector3f = vector3fs[j];
            vector3f.rotate((Quaternionfc)quaternionf);
            vector3f.mul(i);
            vector3f.add(f, g, h);
        }
        float u0 = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        int lightColor = this.getLightColor(partialTicks);
        int lU = VertexUtil.lightU((int)lightColor);
        int lV = VertexUtil.lightV((int)lightColor);
        buffer.addVertex(vector3fs[0].x(), vector3fs[0].y(), vector3fs[0].z()).setUv(u1, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv2(lU, lV);
        buffer.addVertex(vector3fs[1].x(), vector3fs[1].y(), vector3fs[1].z()).setUv(u1, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv2(lU, lV);
        buffer.addVertex(vector3fs[2].x(), vector3fs[2].y(), vector3fs[2].z()).setUv(u0, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv2(lU, lV);
        buffer.addVertex(vector3fs[3].x(), vector3fs[3].y(), vector3fs[3].z()).setUv(u0, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv2(lU, lV);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }
}

